/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModStructures;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFHexPrism;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.config.CommonConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

@Deprecated
public class RoundCaveFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();

    public RoundCaveFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos down;
        if (!(CommonConfig.isNewGeneratorEnabled() && CommonConfig.noRingVoid() || pos.func_177958_n() * pos.func_177958_n() + pos.func_177952_p() * pos.func_177952_p() > 22500)) {
            return false;
        }
        int radius = ModMathHelper.randRange(10, 30, random);
        int top = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        BlockPos.Mutable bpos = new BlockPos.Mutable();
        bpos.func_223471_o(pos.func_177958_n());
        bpos.func_223472_q(pos.func_177952_p());
        bpos.func_185336_p(top - 1);
        BlockState state = world.func_180495_p((BlockPos)bpos);
        while (!state.func_235714_a_(ModTags.GEN_TERRAIN) && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        if (bpos.func_177956_o() < 10) {
            return false;
        }
        top = (int)((float)bpos.func_177956_o() - ((float)radius * 1.3f + 5.0f));
        while (state.func_235714_a_(ModTags.GEN_TERRAIN) || !state.func_204520_s().func_206888_e() && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.func_177956_o() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        pos = new BlockPos(pos.func_177958_n(), ModMathHelper.randRange(bottom, top, random), pos.func_177952_p());
        OpenSimplexNoise noise = new OpenSimplexNoise(ModMathHelper.getSeed(534, pos.func_177958_n(), pos.func_177952_p()));
        int x1 = pos.func_177958_n() - radius - 5;
        int z1 = pos.func_177952_p() - radius - 5;
        int x2 = pos.func_177958_n() + radius + 5;
        int z2 = pos.func_177952_p() + radius + 5;
        int y1 = ModMathHelper.floor((double)pos.func_177956_o() - (double)(radius + 5) / 1.6);
        int y2 = ModMathHelper.floor((double)pos.func_177956_o() + (double)(radius + 5) / 1.6);
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet bushes = Sets.newHashSet();
        BlockState terrain = ((Block)ModBlocks.CAVE_MOSS.get()).func_176223_P();
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.func_177958_n();
            xsq *= xsq;
            bpos.func_223471_o(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.func_177952_p();
                zsq *= zsq;
                bpos.func_223472_q(z);
                for (int y = y1; y <= y2; ++y) {
                    int h;
                    int ysq = y - pos.func_177956_o();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    bpos.func_185336_p(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.func_180495_p((BlockPos)bpos);
                        if (this.isReplaceable(state)) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                            while (state.func_185904_a().equals(Material.field_151584_j)) {
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                                bpos.func_185336_p(bpos.func_177956_o() + 1);
                                state = world.func_180495_p((BlockPos)bpos);
                            }
                            bpos.func_185336_p(y - 1);
                            while (state.func_185904_a().equals(Material.field_151584_j)) {
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                                bpos.func_185336_p(bpos.func_177956_o() - 1);
                                state = world.func_180495_p((BlockPos)bpos);
                            }
                        }
                        bpos.func_185336_p(y - 1);
                        if (!world.func_180495_p((BlockPos)bpos).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, terrain);
                        continue;
                    }
                    if (!(dist < r2 * r2)) continue;
                    state = world.func_180495_p((BlockPos)bpos);
                    if (!state.func_204520_s().func_206888_e()) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, Blocks.field_150377_bs.func_176223_P());
                        continue;
                    }
                    if (!world.func_180495_p((BlockPos)bpos).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                    if (world.func_175623_d(bpos.func_177977_b())) {
                        h = BlockHelper.downRay((IWorldReader)world, bpos.func_177977_b(), 64);
                        if (h <= 6 || h >= 32 || !world.func_180495_p(bpos.func_177979_c(h + 3)).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                        bushes.add(bpos.func_177977_b());
                        continue;
                    }
                    if (!world.func_175623_d(bpos.func_177984_a()) || (h = BlockHelper.upRay((IWorldReader)world, bpos.func_177984_a(), 64)) <= 6 || h >= 32 || !world.func_180495_p(bpos.func_177981_b(h + 3)).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                    bushes.add(bpos.func_177984_a());
                }
            }
        }
        bushes.forEach(cpos -> {
            if (random.nextInt(32) == 0) {
                this.generateBush(world, random, (BlockPos)cpos);
            }
        });
        if (random.nextBoolean() && world.func_226691_t_(pos).func_242440_e().func_242493_a(ModStructures.MOUNTAIN) && this.isReplaceable(world.func_180495_p(down = (pos = pos.func_177963_a(random.nextGaussian() * 5.0, random.nextGaussian() * 5.0, random.nextGaussian() * 5.0)).func_177979_c(BlockHelper.downRay((IWorldReader)world, pos, 64) + 2)))) {
            SDF prism = new SDFHexPrism().setHeight((float)radius * ModMathHelper.randRange(0.6f, 0.75f, random)).setRadius(ModMathHelper.randRange(1.7f, 3.0f, random)).setBlock((Block)ModBlocks.AURORA_CRYSTAL.get());
            Vector3f vec = ModMathHelper.randomHorizontal(random);
            prism = new SDFRotation().setRotation(vec, random.nextFloat()).setSource(prism);
            prism.setReplaceFunction(bState -> bState.func_185904_a().func_76222_j() || bState.func_235714_a_(ModTags.GEN_TERRAIN) || bState.func_185904_a().equals(Material.field_151585_k) || bState.func_185904_a().equals(Material.field_151584_j));
            prism.fillRecursive((IWorld)world, pos);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (Block)ModBlocks.AURORA_CRYSTAL.get());
        }
        BlockHelper.fixBlocks((IWorld)world, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
        return true;
    }

    private boolean isReplaceable(BlockState state) {
        return state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_235714_a_((ITag)Tags.Blocks.ORES) || state.func_235714_a_((ITag)Tags.Blocks.END_STONES) || state.func_185904_a().func_76222_j() || state.func_185904_a().equals(Material.field_151585_k) || state.func_185904_a().equals(Material.field_151584_j);
    }

    private void generateBush(ISeedReader world, Random random, BlockPos blockPos) {
        float radius = MathHelper.func_151240_a((Random)random, (float)1.0f, (float)3.2f);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((Block)ModBlocks.CAVE_BUSH.get());
        sphere = new SDFScale3D().setScale(ModMathHelper.randRange(0.8f, 1.2f, random), ModMathHelper.randRange(0.8f, 1.2f, random), ModMathHelper.randRange(0.8f, 1.2f, random)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 3.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource(sphere));
        sphere.fillRecursive((IWorld)world, blockPos);
        world.func_180501_a(blockPos, ((Block)ModBlocks.CAVE_BUSH.get()).func_176223_P(), 19);
    }
}

